function render(template, dest, language) {
    if ((!language) || (!TEXT[language.toUpperCase()]) || (language.toUpperCase() !== 'NL' && language.toUpperCase() !== 'FR')) {
        language = 'NL';
    }
    var node = document.getElementById(dest);
    if (node == null && dest == 'body') {
        // IE9 fix: IE9 is confused when an ID has the name of a valid tag.
        node = document.body;
    }
    node.innerHTML = Mustache.render(document.getElementById(template).innerHTML, TEXT[language.toUpperCase()]);
    $(document).trigger('rendered');
    initACM();
}

function getLanguage() {
    var language = getCookie('vo-taalkeuze');
    if ((!language) || (!TEXT[language.toUpperCase()]) || (language.toUpperCase() !== 'NL' && language.toUpperCase() !== 'FR')) {
        language = 'NL';
    }
    return language;
}

function saveCookie(data, expires, path, domain) {
    if (expires) {
        var expiredate = new Date();
        expiredate.setDate(expiredate.getDate() + expires);
        var e = ';expires=' + expiredate.toUTCString();
    } else {
        var e = '';
    }
    if (typeof(data) == "object") {
        var cdata = encodeURIComponent(JSON.stringify(data));
    } else {
        var cdata = data;
    }
    if (domain) {
        var d = ";Domain=" + domain;
    } else {
        var d = "";
    }
    if (path) {
        var p = ";Path=" + path;
    } else {
        var p = ";Path=/"
    }
    var p = path || '/';
    return data + d + p + e;
}

function getCookie(check_name) {
    var a_all_cookies = document.cookie.split(';');
    var a_temp_cookie = '';
    var cookie_name = '';
    var cookie_value = '';
    var b_cookie_found = false; // set boolean t/f default f

    for (i = 0; i < a_all_cookies.length; i++) {
        a_temp_cookie = a_all_cookies[i].split('=');
        cookie_name = a_temp_cookie[0].replace(/^\s+|\s+$/g, '');
        if (cookie_name == check_name) {
            b_cookie_found = true;
            if (a_temp_cookie.length > 1) {
                cookie_value = unescape(a_temp_cookie[1].replace(/^\s+|\s+$/g, ''));
            }
            return cookie_value;
            break;
        }
        a_temp_cookie = null;
        cookie_name = '';
    }
    if (!b_cookie_found) {
        return null;
    }
}

function debrand() {
    var elements = $("li.debrandable");
    for (var i = 0; i < Object.keys(elements).length - 4; i++) {
        if (elements[i].classList.contains("debrandable")) elements[i].parentNode.removeChild(elements[i]);
    }

    elements = $(".debrandable");
    for (var i = 0; i < Object.keys(elements).length - 4; i++) {
        if (elements[i].classList.contains("debrandable")) {
            elements[i].classList.remove("debrandable");
            elements[i].classList.add("debranded");
        }
    }
}